package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.GroupTask;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.RequestWorkflow;
import gov.va.vinci.dart.db.GroupTaskDAO;
import gov.va.vinci.dart.service.DartObjectFactory;

public class GroupTaskDAOMock implements GroupTaskDAO {

	private static boolean initialized = false;
	private static final HashMap<Integer,GroupTask> IDHash = new HashMap<Integer,GroupTask>();

	@Override
	public void save(GroupTask groupTask) {

		initializeTaskHash();

		// have TaskDAO allocate an Id to the task
		DartObjectFactory.getInstance().getTaskDAO().save(groupTask);
		
		// and save it in our hash
		IDHash.put(groupTask.getId(), groupTask);
	}

	@Override
	public void delete(GroupTask groupTask) {
		initializeTaskHash();

		//remove this task from the hash
		IDHash.remove(groupTask.getId());
	}
 	
	@Override
	public GroupTask findById(int taskId) {
		initializeTaskHash();
		
		return IDHash.get(taskId);
	}

	@Override
	public List<GroupTask> listByOwner(int ownerId) {
		initializeTaskHash();

		List<GroupTask> result = new ArrayList<GroupTask>();

		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				GroupTask pt = IDHash.get(id);
				if (ownerId == pt.getGroupOwner().getId()) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}

	@Override
	public List<GroupTask> listOpenByOwner(int ownerId) {
		initializeTaskHash();

		List<GroupTask> result = new ArrayList<GroupTask>();

		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				GroupTask pt = IDHash.get(id);
				if (ownerId == pt.getGroupOwner().getId() && pt.getCompletedOn() == null) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}

	@Override
	public List<GroupTask> listOpenByOwnerAndRequestId(int ownerId,
			int requestId) {
		initializeTaskHash();

		List<GroupTask> result = new ArrayList<GroupTask>();

		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				GroupTask pt = IDHash.get(id);
				if (ownerId == pt.getGroupOwner().getId() && pt.getCompletedOn() == null && pt.getRequest().getId() == requestId) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}
	
	
	@Override
	public List<GroupTask> listOpenByWorkflowAndOwnerAndRequestId(int workflowId, int ownerId, int requestId) {
		initializeTaskHash();

		List<GroupTask> result = new ArrayList<GroupTask>();

		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				GroupTask pt = IDHash.get(id);
				if (ownerId == pt.getGroupOwner().getId() && pt.getCompletedOn() == null && pt.getRequest().getId() == requestId) {
					
					if( pt.getWorkflow() != null && pt.getWorkflow().getId() == workflowId ) {	//get the GroupTasks for this workflow
						result.add(pt);
					}

				}
			}
		}
		
		return result;
	}
	
	
	@Override
	public List<GroupTask> listByOwnerAndRequestId(final int ownerId, final int requestId) {
		initializeTaskHash();

		List<GroupTask> result = new ArrayList<GroupTask>();

		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				GroupTask pt = IDHash.get(id);
				if (ownerId == pt.getGroupOwner().getId() && pt.getRequest().getId() == requestId) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}
	
	

	@Override
	public List<GroupTask> listAllGroupTasks() {
		initializeTaskHash();

		List<GroupTask> result = new ArrayList<GroupTask>();

		for (Integer id: IDHash.keySet()) {
			GroupTask pt = IDHash.get(id);
			result.add(pt);
		}

		return result;
	}

	@Override
	public List<GroupTask> listAllOpenGroupTasks() {
		initializeTaskHash();

		List<GroupTask> result = new ArrayList<GroupTask>();

		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				GroupTask pt = IDHash.get(id);
				if (pt.getCompletedOn() == null) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}

	private void initializeTaskHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
	
		try {
			initializeTaskHash0();
		}
		catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}
		catch (ValidationException e) {
			e.printStackTrace();
		}
	}
	
	private void initializeTaskHash0() throws ObjectNotFoundException, ValidationException {
		DartObjectFactory.getInstance().getResearchStudyDAO().listAll();  // to initialize
		
		List<DartRequest> rList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Request request = rList.get(0);
		Group owner = DartObjectFactory.getInstance().getGroupDAO().findById(1);
		
		RequestWorkflow workflow = null;
		List<RequestWorkflow> wList = DartObjectFactory.getInstance().getRequestWorkflowDAO().listAll();
		if( wList != null && wList.size() > 0 ) {
			workflow = wList.get(0);
		}		
		
		GroupTask.create(workflow, request, owner, "test group task 1", "test group task 1", "DNS");
	}

}
